 /*
 * Fixed width font for numbers that looks like LCD panel digits
 * This font including pad pixels, will render 14x24 pixels on the display 
 *
 * This font is very useful when using overstrike as all characters & numbers
 * are all the same width.
 *
 * This font is not a complete character set. The font only contains
 * the characters: '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '9', ':'
 *
 * This font is nice for certain applications like clocks, signed values or decimal point values.
 *
 */
 
// Pixels for S-meter, original: lcdnums12x16.h
// 14.12.2017, Arduino IDE v1.8.5, LZ2WSG, KN34PC

GLCDFONTDECL(labels) =
{
  0x0, 0x0,	// size of zero indicates fixed width font
    17,		// width  (will be 18 with pad pixel on right)
    7,		// height (will be 8 with pad pixel on bottom)
    '+',	   // first char
    17,		// char count
    
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // +

0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ,

0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // -

0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // .

0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // /

0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0

0x00, 0x00, 0x00, 0x00, 0xFC, 0x24, 0x64, 0xA4, 0x98, 0x00, 0x00, 0x84, 0x48, 0x30, 0x48, 0x84, 0x00,  // 1 - RX

0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0xFC, 0x04, 0x04, 0x00, 0x00, 0x84, 0x48, 0x30, 0x48, 0x84, 0x00,  // 2 - TX

0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 3

0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 4

0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0xFC, 0x00, 0x00, 0x78, 0x84, 0x84, 0x78, 0x00, 0x00, 0x00,  // 5 - 10

0x00, 0x00, 0x00, 0x00, 0x9C, 0x94, 0x94, 0x64, 0x00, 0x00, 0x78, 0x84, 0x84, 0x78, 0x00, 0x00, 0x00,  // 6 - 50

0x00, 0x00, 0x10, 0x08, 0xFC, 0x00, 0x00, 0x78, 0x84, 0x84, 0x78, 0x00, 0x00, 0x78, 0x84, 0x84, 0x78,  // 7 - 100

0x00, 0x8C, 0xC4, 0xA4, 0x9C, 0x00, 0x00, 0x9C, 0x94, 0x94, 0x64, 0x00, 0x00, 0x78, 0x84, 0x84, 0x78,  // 8 - 250

0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0xFC, 0x00, 0x00, 0xFC, 0x30, 0x48, 0x84, 0x00, 0x00, 0x00,  // 9 - 1k

0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // :

0x00, 0x10, 0x08, 0xfc, 0x00, 0x78, 0x84, 0x78, 0x00, 0x78, 0x84, 0x78, 0x00, 0xfc, 0x18, 0xe4, 0x00,  // 11 - 100k
};