 /*
 * Fixed width font for numbers that looks like LCD panel digits
 * This font including pad pixels, will render 14x24 pixels on the display 
 *
 * This font is very useful when using overstrike as all characters & numbers
 * are all the same width.
 *
 * This font is not a complete character set. The font only contains
 * the characters: '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '9', ':'
 *
 * This font is nice for certain applications like clocks, signed values or decimal point values.
 *
 */
 
// Pixels for S-meter, original: lcdnums12x16.h
// 14.12.2017, Arduino IDE v1.8.5, LZ2WSG, KN34PC

GLCDFONTDECL(pixels) =
{
  0x0, 0x0,	// size of zero indicates fixed width font
    8,		// width  (will be 9 with pad pixel on right)
    7,		// height (will be 8 with pad pixel on bottom)
    '+',	   // first char
    16,		// char count
    
0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0,  // +

0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ,

0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0,  // -

0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00,  // .

0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // /

0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 0 no pixels / празен символ

0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,  // 1 thin dash 1px / тънко тире

0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0,  // 2 thick dash 2px / дебело тире

0xF0, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0xF0,  // 3 hollow rectangle 4px / кух правоъгълник

0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0,  // 4 filled rectangle 4px / запълнен правоъгълник

0xF8, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0xF8,  // 5 hollow rectangle 5px / кух правоъгълник

0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8,  // 6 filled rectangle 5px / запълнен правоъгълник

0xFC, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0xFC,  // 7 hollow rectangle 6px / кух правоъгълник

0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC,  // 8 filled rectangle 6px / запълнен правоъгълник

0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 9

0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // :
};